<?php

namespace ZS\Usaepay\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\DB\Ddl\Table;

/**
 * Class InstallSchema
 * @package ZS\Usaepay\Setup
 */
class UpgradeSchema implements UpgradeSchemaInterface
{

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;

        $installer->startSetup();

        
        // create table 'usapay_gateway_stored_card'
        if (version_compare($context->getVersion(), '2.0.1') < 0) {
            if (!$installer->tableExists('usapay_gateway_stored_card')) {
                $table = $installer->getConnection()
                    ->newTable($installer->getTable('usapay_gateway_stored_card'))
                    ->addColumn(
                        'card_id',
                        Table::TYPE_INTEGER,
                        null,
                        ['identity' => true, 'nullable' => false, 'primary' => true]
                    )
                    ->addColumn('customer_id', Table::TYPE_INTEGER, null, ['nullable' => false])
                    ->addColumn('cc_token', Table::TYPE_TEXT, 255, ['nullable' => false])
                    ->addColumn('cc_exp_month', Table::TYPE_INTEGER, null, ['nullable' => false])
                    ->addColumn('cc_exp_year', Table::TYPE_INTEGER, null, ['nullable' => false])
                    ->addColumn('cc_type', Table::TYPE_TEXT, 255, ['nullable' => false])
                    ->addColumn('cc_last_4', Table::TYPE_TEXT, 4, ['nullable' => false])
                    ->addColumn('created_at', Table::TYPE_DATETIME, null, ['nullable' => true])
                    ->addColumn('updated_at', Table::TYPE_DATETIME, null, ['nullable' => true])
                    ->addColumn('is_active', Table::TYPE_SMALLINT, null, ['nullable' => true, 'default' => 1]);

                $installer->getConnection()->createTable($table);
            }
        }

        $installer->endSetup();
    }

}